#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  4dwarp4Mod01.fsh    by   pb  
//https://www.shadertoy.com/view/l3VyRy
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

#define rot(a) mat2(cos(a+vec4(0,11,33,0)))

//formula for creating colors;
#define H(h)  (  cos( h*2. + 7.*vec3(1,2,3) )*.6 + .3 )

//formula for mapping scale factor 
#define M(c)  log(1.+c)

#define R iResolution
#define O fragColor
#define U fragCoord

//void mainImage( out vec4 O, vec2 U) {
 //void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{  
    
    float wfac = .7, zoom=0., cfac=0.;

    O = vec4(0); 
    vec3 c=vec3(0);  
    vec4 rd = normalize( vec4(U-.5*R.xy, .8*R.y, wfac*R.y))*15.; 

    float sc,dotp,totdist=0., t=2.91; 
           
    float fac=.54;

    
    for (float i=0.; i<100.; i++) {
        
        vec4 p = vec4( rd*totdist );
        
        p.x -= .9;
        p.z += iTime/3.;
 
        p.z = mod(p.z,6.)-3.;  //rinse repeat
        
        p.xy *= rot( t*(1.+wfac) + sin(t/2.) );
        p.yz *= rot(.707 + t/2. );
        p.xz *= rot(.707 + t/5. );
        
        sc = 1.;  
       
        for (float j=0.; j<7.; j++) {
        
            p = abs( p - .9 )*.6;
            
            dotp = max(1./dot(p,p),fac);
            sc *= dotp;

            p=p.x<p.y?p.wzxy:p.wzyx;
            p=p.z<p.w?p.xywz:p.xyzw;
            p=p.y<p.z?p.xwyz:p.xwzy;
            
            p *= dotp - .2*p;
            
        }
 
        float dist = clamp(abs( length(p-p.w) -.35)/(1.+sc),1e-4,.006) ; 
        float stepsize = dist + 1e-4  ;
        totdist += stepsize;    

        c += .03 * H(M(sc)) * exp(-i*i*stepsize*stepsize*1e3)
        ;
            

    }
    
    c = clamp(c,-100.,100.);

    c = 1. - exp(-c*c);

    c *= exp(-totdist*totdist/2.);
    
    c.b *= 1.5;

    fragColor = ( vec4(c,0) );
////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

